'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 16 March 2006 at 11:58:44 am'!
Smalltalk renameClassNamed: #MacQuicktimePlugin as: #QuicktimePlugin!
SmartSyntaxInterpreterPlugin subclass: #QuicktimePlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMMaker-Plugins'!

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 1/17/2006 15:53'!
initialiseModule
	self export: true.
	^self sqQuicktimeInitialize ! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 1/17/2006 15:53'!
moduleUnloaded: aModuleName 
	"The module with the given name was just unloaded. 
	Make sure we have no dangling references."
	self export: true.
	self var: #aModuleName type: 'char *'.
	(aModuleName strcmp: 'QuicktimePlugin') = 0
		ifTrue: [self sqQuicktimeShutdown]! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 1/17/2006 23:05'!
primitiveClearFrameCompletedSemaphore: data

	self primitive: 'primitiveClearFrameCompletedSemaphore' parameters: #(SmallInteger).
	self stQuicktimeClearSemaphore: data.
	^nil! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 1/17/2006 23:05'!
primitiveDestroyHandle: data 

	self primitive: 'primitiveDestroyHandle' parameters: #(SmallInteger).
	self stQuicktimeDestroy: data.
	^nil! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 3/16/2006 09:32'!
primitiveDestroySurface: data 

	self primitive: 'primitiveDestroySurface' parameters: #(SmallInteger).
	self stQuicktimeDestroySurface: data.
	^nil! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 1/17/2006 23:06'!
primitiveSetFrameCompletedSemaphore: semaIndex for: data

	self primitive: 'primitiveSetFrameCompletedSemaphore'  parameters:#(SmallInteger SmallInteger).
	self stQuicktimeSetSemaphore: semaIndex for: data.
	^nil! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 3/16/2006 11:30'!
primitiveSetGWorldPtrOntoExistingSurface: surfaceID gWorld: bitMapPtr width: width height: height rowBytes: rowBytes depth: depth movie: moviePtr
	| buffer movie |

	self primitive: 'primitiveSetGWorldPtrOntoExistingSurface'  parameters:#(SmallInteger Oop SmallInteger SmallInteger SmallInteger SmallInteger Oop).
	buffer := self cCoerce: (interpreterProxy positive32BitValueOf: bitMapPtr) to: 'char *'.
	movie := self cCoerce: (interpreterProxy positive32BitValueOf: moviePtr) to: 'long'.
	self stQuicktimeSetToExistingSurface: surfaceID gworld: buffer width: width height: height rowBytes: rowBytes depth: depth movie: movie.
	! !

!QuicktimePlugin methodsFor: 'system primitives' stamp: 'JMM 3/16/2006 11:30'!
primitiveSetGWorldPtrOntoSurface: bitMapPtr width: width height: height rowBytes: rowBytes depth: depth movie: moviePtr
	| buffer movie results |

	self primitive: 'primitiveSetGWorldPtrOntoSurface'  parameters:#(Oop SmallInteger SmallInteger SmallInteger SmallInteger Oop).
	buffer := self cCoerce: (interpreterProxy positive32BitValueOf: bitMapPtr) to: 'char *'.
	movie := self cCoerce: (interpreterProxy positive32BitValueOf: moviePtr) to: 'long'.
	results := self stQuicktimeSetSurface: buffer width: width height: height rowBytes: rowBytes depth: depth movie: movie.
	^results asOop: SmallInteger ! !


!QuicktimePlugin class methodsFor: 'translation' stamp: 'JMM 1/17/2006 20:24'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !

!QuicktimePlugin class methodsFor: 'translation' stamp: 'JMM 1/17/2006 20:24'!
requiresCrossPlatformFiles
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !


!QuicktimePlugin class reorganize!
('translation' hasHeaderFile requiresCrossPlatformFiles)
!

QuicktimePlugin removeSelector: #primitiveClearFrameCompletedSemaphore!
QuicktimePlugin removeSelector: #primitiveDestoryHandle:!
QuicktimePlugin removeSelector: #primitiveSetFrameCompletedSemaphore:!
QuicktimePlugin removeSelector: #primitiveSetGWorldPtrOntoSurface:width:height:!
QuicktimePlugin removeSelector: #primitiveSetGWorldPtrOntoSurface:width:height:rowBytes:!
QuicktimePlugin removeSelector: #primitiveSetGWorldPtrOntoSurface:width:height:rowBytes:depth:!

!QuicktimePlugin reorganize!
('system primitives' initialiseModule moduleUnloaded: primitiveClearFrameCompletedSemaphore: primitiveDestroyHandle: primitiveDestroySurface: primitiveSetFrameCompletedSemaphore:for: primitiveSetGWorldPtrOntoExistingSurface:gWorld:width:height:rowBytes:depth:movie: primitiveSetGWorldPtrOntoSurface:width:height:rowBytes:depth:movie:)
!

